//
//  MCSourceListNavigationView.h
//  MCApplication
//
//  Created by Michael Clark on 05/07/2005.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCNibLoadingView.h"


@class MCSplitView, MCButtonGrid, MCDocument;

@interface MCSourceListNavigationView : MCNibLoadingView {
	IBOutlet MCSplitView*            splitView;

	IBOutlet MCButtonGrid*            buttonGrid;

	NSMutableDictionary*  _sourceListTypeViewCache;
	NSDictionary*         _selectedSourceListTypeConfig; 
	
	BOOL   _configured;
	
	MCDocument*    _document;
	NSWindow      *_mainWindow;
}
- (void)prepareForRelease;

- (IBAction)buttonGridButtonDidAct:(id)sender;

- (void)selectButtonWithIdentifier: (NSString*)identifier;

- (id)listView;

// Accessors
- (NSMutableDictionary *)sourceListTypeViewCache;
- (void)setSourceListTypeViewCache:(NSMutableDictionary *)aSourceListTypeViewCache;

- (NSDictionary *)selectedSourceListTypeConfig;
- (void)setSelectedSourceListTypeConfig:(NSDictionary *)aSelectedSourceListTypeConfig;

- (MCDocument *)document;
- (void)setDocument:(MCDocument *)aDocument;

- (NSWindow *)mainWindow;
- (void)setMainWindow:(NSWindow *)aMainWindow;
@end
